@COMMENT:Tworzenie wpisu wersji
^
INSERT INTO EW_APP_VERSION (DB_VERSION, BIN_VERSION, UPGRADE_DATE, USER_NAME, IS_FINISHED) VALUES (3, '1.0.0.0', CURRENT_TIMESTAMP, 'ADMIN', 0);
^
@COMMENT:Tworzenie tabeli kontaktów
^
ALTER TABLE R3_CONTACTS ADD HO_EFAKTURA  SMALLINT DEFAULT 0 NOT NULL;
^
ALTER TABLE R3_CONTACTS ADD HO_OD_DATY DATE;
^
@COMMENT:Tworzenie tabeli wysyłki faktur
^
CREATE TABLE EW_WYSYLKA_FAKTUR (
	ID					 INTEGER NOT NULL,
	EMAIL				 VARCHAR(60),
	STATUS_WYSYLKI		 SMALLINT,
	PLIK				 VARCHAR(40),
	DATA_WYSYLKI		 TIMESTAMP,
	OPERATOR			 VARCHAR(15),
	DATA_UTWORZENIA		 TIMESTAMP,
	DUPLIKAT			 SMALLINT DEFAULT 0 NOT NULL
);
^
ALTER TABLE EW_WYSYLKA_FAKTUR ADD CONSTRAINT PK_EW_WYSYLKA_FAKTUR PRIMARY KEY (ID);
^
CREATE TABLE EW_WYSYLKA_FAKTUR_LOG (
	ID					 INTEGER NOT NULL,
	ID_FS				 INTEGER NOT NULL,
	STATUS_WYSYLKI		 SMALLINT,
	DATA_WYSYLKI		 TIMESTAMP,
	BLAD				 VARCHAR(500),
	DUPLIKAT			 SMALLINT DEFAULT 0 NOT NULL
);
^
ALTER TABLE EW_WYSYLKA_FAKTUR_LOG ADD CONSTRAINT PK_EW_WYSYLKA_FAKTUR_LOG PRIMARY KEY (ID);
^
CREATE INDEX EW_WYSYLKA_FAKTUR_LOG_IDX1 ON EW_WYSYLKA_FAKTUR_LOG(ID_FS);
^
CREATE GENERATOR EW_WYSYLKA_FAKTUR_LOG_ID_GEN;
^
CREATE TRIGGER BI_EW_WYSYLKA_FAKTUR_LOG_ID FOR EW_WYSYLKA_FAKTUR_LOG
ACTIVE BEFORE INSERT
POSITION 0
AS
BEGIN
  IF (NEW.ID IS NULL) THEN
      NEW.ID = GEN_ID(EW_WYSYLKA_FAKTUR_LOG_ID_GEN, 1);
END
^
CREATE TABLE EW_INV_REP (
	ID		 INTEGER NOT NULL,
	DEFINICJA BLOB SUB_TYPE 1 NOT NULL,
	ZMIENIL VARCHAR(40) CHARACTER SET WIN1250 COLLATE PXW_PLK,
	DATA_ZMIANY TIMESTAMP
);
^
ALTER TABLE EW_INV_REP ADD CONSTRAINT PK_EW_INV_REP PRIMARY KEY (ID);
^
@COMMENT:Tworzenie kontekstów aplikacji
^
INSERT INTO EW_UPR_KONTEKSTY
VALUES (15, 'Wysyłka e-faktur');
^
@COMMENT:Dodanie nowych uprawnień
^
INSERT INTO EW_UPR
VALUES (33, 'Czytaj', 15);
^
INSERT INTO EW_UPR
VALUES (34, 'Edytuj', 15);
^
INSERT INTO EW_UPR
VALUES (35, 'Usuń', 15);
^
INSERT INTO EW_UPR
VALUES (36, 'Wyślij', 15);
^
INSERT INTO EW_UPR_ROLI
VALUES (33, 1);
^
INSERT INTO EW_UPR_ROLI
VALUES (34, 1);
^
INSERT INTO EW_UPR_ROLI
VALUES (35, 1);
^
INSERT INTO EW_UPR_ROLI
VALUES (36, 1);
^
@COMMENT:Odblokowanie bazy danych
^
UPDATE EW_APP_VERSION SET IS_FINISHED = 1 WHERE DB_VERSION = 3;