@COMMENT:Tworzenie wpisu wersji
^
INSERT INTO EW_APP_VERSION (DB_VERSION, BIN_VERSION, UPGRADE_DATE, USER_NAME, IS_FINISHED) VALUES (2, '1.0.0.0', CURRENT_TIMESTAMP, 'ADMIN', 0);
^
@COMMENT:Tworzenie tabeli szablonów monitów
^
CREATE TABLE EW_SZABLONY_MONITOW (
  ID INTEGER NOT NULL,
  KANAL_WYSYLKI SMALLINT NOT NULL,
  NAZWA VARCHAR(200) CHARACTER SET WIN1250 NOT NULL COLLATE PXW_PLK,
  TYTUL VARCHAR(200) CHARACTER SET WIN1250 COLLATE PXW_PLK,
  TRESC BLOB SUB_TYPE 1 NOT NULL,
  WORD_DOK BLOB SUB_TYPE 1 NOT NULL,
  UTWORZYL VARCHAR(40) CHARACTER SET WIN1250 NOT NULL COLLATE PXW_PLK,
  DATA_UTWORZENIA TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
  ZMIENIL VARCHAR(40) CHARACTER SET WIN1250 COLLATE PXW_PLK,
  DATA_ZMIANY TIMESTAMP,
  ARCHIWALNY SMALLINT DEFAULT 0 NOT NULL);
^
ALTER TABLE EW_SZABLONY_MONITOW ADD PRIMARY KEY (ID);
^
CREATE GENERATOR EW_SZABLONY_MONITOW_ID_GEN;
^
CREATE TRIGGER BI_EW_SZABLONY_MONITOW_ID FOR EW_SZABLONY_MONITOW
ACTIVE BEFORE INSERT
POSITION 0
AS
BEGIN
  IF (NEW.ID IS NULL) THEN
      NEW.ID = GEN_ID(EW_SZABLONY_MONITOW_ID_GEN, 1);
END
^
@COMMENT:Tworzenie tabeli procedur wysyłki
^
CREATE TABLE EW_PROCEDURY_WYSYLKI (
  ID INTEGER NOT NULL,
  DOMYSLNIE_WLACZONA SMALLINT NOT NULL,
  NAZWA VARCHAR(200) CHARACTER SET WIN1250 NOT NULL COLLATE PXW_PLK,
  UTWORZYL VARCHAR(40) CHARACTER SET WIN1250 NOT NULL COLLATE PXW_PLK,
  DATA_UTWORZENIA TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
  ZMIENIL VARCHAR(40) CHARACTER SET WIN1250 COLLATE PXW_PLK,
  DATA_ZMIANY TIMESTAMP,
  ARCHIWALNY SMALLINT DEFAULT 0 NOT NULL);
^
ALTER TABLE EW_PROCEDURY_WYSYLKI ADD PRIMARY KEY (ID);
^
CREATE GENERATOR EW_PROCEDURY_WYSYLKI_ID_GEN;
^
CREATE TRIGGER BI_EW_PROCEDURY_WYSYLKI_ID FOR EW_PROCEDURY_WYSYLKI
ACTIVE BEFORE INSERT
POSITION 0
AS
BEGIN
  IF (NEW.ID IS NULL) THEN
      NEW.ID = GEN_ID(EW_PROCEDURY_WYSYLKI_ID_GEN, 1);
END
^
@COMMENT:Tworzenie tabeli kroków procedur wysyłki
^
CREATE TABLE EW_KROKI_PROCEDURY_WYS (
  ID INTEGER NOT NULL,
  ID_PROCEDURY_WYSYLKI INTEGER NOT NULL,
  NAZWA VARCHAR(200) CHARACTER SET WIN1250 NOT NULL COLLATE PXW_PLK,
  WYSYLAJ_MONIT_OD INTEGER NOT NULL,
  WYSYLAJ_MONIT_OD_TRYB SMALLINT NOT NULL,
  WYSYLAJ_MONIT_DO INTEGER NOT NULL,
  WYSYLAJ_MONIT_DO_TRYB SMALLINT NOT NULL,
  MINIMALNA_KWOTA  NUMERIC(15,2) NOT NULL,
  KANAL_WYSYLKI SMALLINT NOT NULL,
  ID_SZABLONU INTEGER NOT NULL,
  UTWORZYL VARCHAR(40) CHARACTER SET WIN1250 NOT NULL COLLATE PXW_PLK,
  DATA_UTWORZENIA TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
  ZMIENIL VARCHAR(40) CHARACTER SET WIN1250 COLLATE PXW_PLK,
  DATA_ZMIANY TIMESTAMP,
  ARCHIWALNY SMALLINT DEFAULT 0 NOT NULL);
^
ALTER TABLE EW_KROKI_PROCEDURY_WYS ADD PRIMARY KEY (ID);
^
CREATE GENERATOR EW_KROKI_PROCEDURY_WYS_ID_GEN;
^
CREATE TRIGGER BI_EW_KROKI_PROCEDURY_WYS_ID FOR EW_KROKI_PROCEDURY_WYS
ACTIVE BEFORE INSERT
POSITION 0
AS
BEGIN
  IF (NEW.ID IS NULL) THEN
      NEW.ID = GEN_ID(EW_KROKI_PROCEDURY_WYS_ID_GEN, 1);
END
^
@COMMENT:Tworzenie tabeli wykluczeń kontrahentów
^
CREATE TABLE EW_WYKLUCZENI_KONT_WIND (
  ID_KONTRAHENTA INTEGER NOT NULL,
  UTWORZYL VARCHAR(40) CHARACTER SET WIN1250 NOT NULL COLLATE PXW_PLK,
  DATA_UTWORZENIA TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL);
^
ALTER TABLE EW_WYKLUCZENI_KONT_WIND ADD PRIMARY KEY (ID_KONTRAHENTA);
^
@COMMENT:Tworzenie tabeli kolejki monitów
^
CREATE TABLE EW_KOLEJKA_MONITOW (
  ID INTEGER NOT NULL,
  ID_KONTRAHENTA INTEGER NOT NULL,
  ID_KROKU_PROCEDURY INTEGER NOT NULL,
  ID_FAKTURY INTEGER,
  ADRES_TELEFON VARCHAR(200) CHARACTER SET WIN1250 NOT NULL COLLATE PXW_PLK,
  TRESC BLOB SUB_TYPE 1 NOT NULL,  
  STATUS_WYSYLKI SMALLINT NOT NULL,
  BLAD SMALLINT NOT NULL,
  UTWORZYL VARCHAR(40) CHARACTER SET WIN1250 NOT NULL COLLATE PXW_PLK,
  DATA_UTWORZENIA TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
  WYSLAL VARCHAR(40) CHARACTER SET WIN1250 COLLATE PXW_PLK,
  DATA_WYSLANIA TIMESTAMP);
^
ALTER TABLE EW_KOLEJKA_MONITOW ADD PRIMARY KEY (ID);
^
CREATE GENERATOR EW_KOLEJKA_MONITOW_ID_GEN;
^
CREATE TRIGGER BI_EW_KOLEJKA_MONITOW_ID FOR EW_KOLEJKA_MONITOW
ACTIVE BEFORE INSERT
POSITION 0
AS
BEGIN
  IF (NEW.ID IS NULL) THEN
      NEW.ID = GEN_ID(EW_KOLEJKA_MONITOW_ID_GEN, 1);
END
^
@COMMENT:Tworzenie tabeli błędów wysyłki
^
CREATE TABLE EW_BLEDY_WYSYLKI (
  ID INTEGER NOT NULL,
  ID_KOLEJKI_MONITOW INTEGER NOT NULL,
  BLAD VARCHAR(500) CHARACTER SET WIN1250 NOT NULL COLLATE PXW_PLK,
  STOS_BLEDU BLOB SUB_TYPE 1 NOT NULL,  
  DATA_UTWORZENIA TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL);
^
ALTER TABLE EW_BLEDY_WYSYLKI ADD PRIMARY KEY (ID);
^
CREATE GENERATOR EW_BLEDY_WYSYLKI_ID_GEN;
^
CREATE TRIGGER BI_EW_BLEDY_WYSYLKI_ID FOR EW_BLEDY_WYSYLKI
ACTIVE BEFORE INSERT
POSITION 0
AS
BEGIN
  IF (NEW.ID IS NULL) THEN
      NEW.ID = GEN_ID(EW_BLEDY_WYSYLKI_ID_GEN, 1);
END
^
@COMMENT:Odblokowanie bazy danych
^
UPDATE EW_APP_VERSION SET IS_FINISHED = 1 WHERE DB_VERSION = 2;