@COMMENT:Tworzenie struktury bazy danych wersji 1
^
CREATE TABLE EW_APP_VERSION (
  ID INTEGER NOT NULL,
  DB_VERSION INTEGER NOT NULL,
  BIN_VERSION VARCHAR(50) CHARACTER SET WIN1250 NOT NULL COLLATE PXW_PLK,
  UPGRADE_DATE TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
  USER_NAME VARCHAR(20) CHARACTER SET WIN1250 NOT NULL COLLATE PXW_PLK,
  IS_FINISHED SMALLINT DEFAULT 0 NOT NULL);
^
ALTER TABLE EW_APP_VERSION ADD PRIMARY KEY (ID);
^
CREATE GENERATOR EW_APP_VERSION_ID_GEN;
^
CREATE TRIGGER BI_EW_APP_VERSION_ID FOR EW_APP_VERSION
ACTIVE BEFORE INSERT
POSITION 0
AS
BEGIN
  IF (NEW.ID IS NULL) THEN
      NEW.ID = GEN_ID(EW_APP_VERSION_ID_GEN, 1);
END
^
@COMMENT:Tworzenie wpisu wersji
^
INSERT INTO EW_APP_VERSION (DB_VERSION, BIN_VERSION, UPGRADE_DATE, USER_NAME, IS_FINISHED) VALUES (1, '1.0.0.0', CURRENT_TIMESTAMP, 'ADMIN', 0);
^
CREATE TABLE EW_UPR_KONTEKSTY (
  ID INTEGER NOT NULL,
  NAZWA VARCHAR(100) CHARACTER SET WIN1250 NOT NULL COLLATE PXW_PLK);
^
ALTER TABLE EW_UPR_KONTEKSTY ADD CONSTRAINT PK_EW_UPR_KONTEKSTY PRIMARY KEY (ID);
^
CREATE GENERATOR EW_UPR_KONTEKSTY_ID_GEN;
^
CREATE TRIGGER BI_EW_UPR_KONTEKSTY_ID FOR EW_UPR_KONTEKSTY
ACTIVE BEFORE INSERT
POSITION 0
AS
BEGIN
  IF (NEW.ID IS NULL) THEN
      NEW.ID = GEN_ID(EW_UPR_KONTEKSTY_ID_GEN, 1);
END
^

CREATE TABLE EW_UPR (
  ID INTEGER NOT NULL,
  NAZWA VARCHAR(50) CHARACTER SET WIN1250 NOT NULL COLLATE PXW_PLK,
  ID_KONTEKSTU INTEGER NOT NULL);
^
ALTER TABLE EW_UPR ADD CONSTRAINT PK_EW_UPR PRIMARY KEY (ID);
^
ALTER TABLE EW_UPR ADD CONSTRAINT UQ_EW_UPR UNIQUE (NAZWA,ID_KONTEKSTU);
^
CREATE GENERATOR EW_UPR_ID_GEN;
^
CREATE TRIGGER BI_EW_UPR_ID FOR EW_UPR
ACTIVE BEFORE INSERT
POSITION 0
AS
BEGIN
  IF (NEW.ID IS NULL) THEN
      NEW.ID = GEN_ID(EW_UPR_ID_GEN, 1);
END
^

CREATE TABLE EW_ROLE (
  ID INTEGER NOT NULL,
  NAZWA VARCHAR(50) CHARACTER SET WIN1250 NOT NULL COLLATE PXW_PLK);
^
ALTER TABLE EW_ROLE ADD CONSTRAINT PK_EW_ROLE PRIMARY KEY (ID);
^
ALTER TABLE EW_ROLE ADD CONSTRAINT UQ_EW_ROLE UNIQUE (NAZWA);
^
CREATE GENERATOR EW_ROLE_ID_GEN;
^
CREATE TRIGGER BI_EW_ROLE_ID FOR EW_ROLE
ACTIVE BEFORE INSERT
POSITION 0
AS
BEGIN
  IF (NEW.ID IS NULL) THEN
      NEW.ID = GEN_ID(EW_ROLE_ID_GEN, 1);
END
^

CREATE TABLE EW_UPR_ROLI (
  ID_UPR INTEGER NOT NULL,
  ID_ROLI INTEGER NOT NULL);
^
ALTER TABLE EW_UPR_ROLI ADD CONSTRAINT PK_EW_UPR_ROLI PRIMARY KEY (ID_UPR,ID_ROLI);
^

CREATE TABLE EW_UZYTKOWNICY (
  ID INTEGER NOT NULL,
  NAZWA VARCHAR(40) CHARACTER SET WIN1250 NOT NULL COLLATE PXW_PLK,
  NAZWA_WYSWIETLANA VARCHAR(100) CHARACTER SET WIN1250 NOT NULL COLLATE PXW_PLK,
  HASLO VARCHAR(50) CHARACTER SET WIN1250 NOT NULL COLLATE PXW_PLK,
  UTWORZYL VARCHAR(40) CHARACTER SET WIN1250 NOT NULL COLLATE PXW_PLK,
  DATA_UTWORZENIA TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
  ZMIENIL VARCHAR(40) CHARACTER SET WIN1250 COLLATE PXW_PLK,
  DATA_ZMIANY TIMESTAMP,
  STATUS SMALLINT DEFAULT 1 NOT NULL,
  ID_KONTAKTU INTEGER,
  ID_POJAZDU INTEGER);
^
ALTER TABLE EW_UZYTKOWNICY ADD CONSTRAINT PK_EW_UZYTKOWNICY PRIMARY KEY (ID);
^
ALTER TABLE EW_UZYTKOWNICY ADD CONSTRAINT UQ_EW_UZYTKOWNICY UNIQUE (NAZWA);
^
CREATE GENERATOR EW_UZYTKOWNICY_ID_GEN;
^
CREATE TRIGGER BI_EW_UZYTKOWNICY_ID FOR EW_UZYTKOWNICY
ACTIVE BEFORE INSERT
POSITION 0
AS
BEGIN
  IF (NEW.ID IS NULL) THEN
      NEW.ID = GEN_ID(EW_UZYTKOWNICY_ID_GEN, 1);
END
^

CREATE TABLE EW_UPR_UZYTKOWNIKA (
  ID_UPR INTEGER NOT NULL,
  ID_UZYTKOWNIKA INTEGER NOT NULL,
  TYP SMALLINT DEFAULT 0 NOT NULL);
^
ALTER TABLE EW_UPR_UZYTKOWNIKA ADD CONSTRAINT PK_EW_UPR_UZYTKOWNIKA PRIMARY KEY (ID_UPR,ID_UZYTKOWNIKA);
^

CREATE TABLE EW_UZYTKOWNICY_ROLE (
  ID_ROLI INTEGER NOT NULL,
  ID_UZYTKOWNIKA INTEGER NOT NULL);
^
ALTER TABLE EW_UZYTKOWNICY_ROLE ADD CONSTRAINT PK_EW_UZYTKOWNICY_ROLE PRIMARY KEY (ID_ROLI,ID_UZYTKOWNIKA);
^

CREATE TABLE EW_BLOKADY (
  ID BIGINT NOT NULL,
  SESJA VARCHAR(40) CHARACTER SET WIN1250 NOT NULL COLLATE PXW_PLK,
  DATA_ZAL TIMESTAMP NOT NULL,
  DATA_WYG TIMESTAMP NOT NULL,
  HOST VARCHAR(100) CHARACTER SET WIN1250 NOT NULL COLLATE PXW_PLK,
  IP VARCHAR(20) CHARACTER SET WIN1250 NOT NULL COLLATE PXW_PLK,
  UZYTKOWNIK VARCHAR(30) CHARACTER SET WIN1250 NOT NULL COLLATE PXW_PLK,
  KONTEKST VARCHAR(50) CHARACTER SET WIN1250 NOT NULL COLLATE PXW_PLK,
  ID_WIERSZA INTEGER NOT NULL);
^
ALTER TABLE EW_BLOKADY ADD CONSTRAINT PK_EW_BLOKADY PRIMARY KEY (ID);
^
ALTER TABLE EW_BLOKADY ADD CONSTRAINT UQ_EW_BLOKADY UNIQUE (KONTEKST,ID_WIERSZA);
^
CREATE GENERATOR EW_BLOKADY_ID_GEN;
^
CREATE TRIGGER BI_EW_BLOKADY_ID FOR EW_BLOKADY
ACTIVE BEFORE INSERT
POSITION 0
AS
BEGIN
  IF (NEW.ID IS NULL) THEN
      NEW.ID = GEN_ID(EW_BLOKADY_ID_GEN, 1);
END
^
CREATE TABLE EW_GLOBAL_SETTINGS (
  ID INTEGER NOT NULL,
  PARAM_NAME VARCHAR(50) CHARACTER SET WIN1250 NOT NULL COLLATE PXW_PLK,
  PARAM_VALUE VARCHAR(1000) CHARACTER SET WIN1250 COLLATE PXW_PLK);
^
ALTER TABLE EW_GLOBAL_SETTINGS ADD CONSTRAINT PK_EW_GLOBAL_SETTINGS PRIMARY KEY (ID);
^
ALTER TABLE EW_GLOBAL_SETTINGS ADD CONSTRAINT UQ_EW_GLOBAL_SETTINGS UNIQUE (PARAM_NAME);
^
CREATE GENERATOR EW_GLOBAL_SETTINGS_ID_GEN;
^
CREATE TRIGGER BI_EW_GLOBAL_SETTINGS_ID FOR EW_GLOBAL_SETTINGS
ACTIVE BEFORE INSERT
POSITION 0
AS
BEGIN
  IF (NEW.ID IS NULL) THEN
      NEW.ID = GEN_ID(EW_GLOBAL_SETTINGS_ID_GEN, 1);
END
^
INSERT INTO EW_GLOBAL_SETTINGS (PARAM_NAME, PARAM_VALUE)
VALUES ('ATTACHMENT_VFS', 'baza_danych');